<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;

class PropertyGroup extends Model 
{

    protected $table = 'lim_property_groups';
    public $timestamps = true;
    protected $fillable = array('table_type', 'table_id', 'rank');
    protected $visible = array('table_type', 'table_id', 'rank');

    public function table()
    {
        return $this->morphTo();
    }

    public function language()
    {
        return $this->hasOne('App\Model\PropertyGroupLanguage', 'lim_property_group_id')->where('lim_language_id', \Config::get('app.language_id'));
    }

    public function languages()
    {
        return $this->hasMany('App\Model\PropertyGroupLanguage', 'lim_property_group_id');
    }

    public function properties()
    {
        return $this->hasMany('App\Models\Property', 'lim_property_group_id');
    }

}